#ifndef Cbob_h
#define Cbob_h

#include <GL\gl.h>
#include <GL\glu.h>

#include "Vecteur.h"
#include "matrice.h"

#define NBLASER 10
#define NBMISSILE 4

#define SCL_SHIP2 (16.0*4)
#define SCL_SHIP3 (16.0*4)
#define SCL_SHIP4 (16.0*4)
#define SCL_SHIP5 (16.0*4)
#define SCL_SHIP6 (16.0*4)
#define SCL_SHIP7 (16.0*4)
#define SCL_SHIP8 (16.0*4)
#define SCL_SHIP9 (16.0*4)
#define SCL_LAUNCHER1 0.3
#define SCL_TURRET1 0.3

#define MISSILE1 2
#define MISSILE2 MISSILE1+1
#define MISSILE3 MISSILE2+1
#define MISSILE4 MISSILE3+1
#define MISSILE5 MISSILE4+1

#define SHIP1 MISSILE5+1
#define SHIP2 SHIP1+1

#define SHIP3 SHIP2+1
#define SHIP4 SHIP3+1
#define SHIP5 SHIP4+1
#define SHIP6 SHIP5+1

#define SHIP7 SHIP6+1
#define SHIP8 SHIP7+1
#define SHIP9 SHIP8+1

#define LAUNCHER1_B SHIP9+1
#define LAUNCHER1_N LAUNCHER1_B+1
#define LAUNCHER1_H LAUNCHER1_N+1
#define LAUNCHER1_HB LAUNCHER1_H+1

#define TURRET1_B LAUNCHER1_HB+1
#define TURRET1_N TURRET1_B+1
#define TURRET1_H TURRET1_N+1
#define TURRET1_HB TURRET1_H+1


#define LASERBLEU TURRET1_HB+1
#define LASERROUGE LASERBLEU+1
#define LASERVERT LASERROUGE+1
#define LASERCYAN LASERVERT+1
#define LASERJAUNE LASERCYAN+1

#define LASERBLEU_BIG LASERJAUNE+1
#define LASERROUGE_BIG LASERBLEU_BIG+1
#define LASERVERT_BIG LASERROUGE_BIG+1
#define LASERCYAN_BIG LASERVERT_BIG+1
#define LASERJAUNE_BIG LASERCYAN_BIG+1

class CbobRefTex;

class Cbob
{
    friend class CbobRefTex;
    
    protected:
        GLint objId;
        
    public:
        Cbob();
        virtual ~Cbob();
        
        //Chargement d'objet non textur (tx ty tz est le dcallage de l'objet par rapport au centre)
        bool loadObj(char *fname,float scale=1.0,float tx=0.0,float ty=0.0,float tz=0.0);
        
        //Chargement d'objet textur
        bool loadObjT(char *fname,float scale=1.0,float tx=0.0,float ty=0.0,float tz=0.0);
        
        virtual void clear();//cette classe supprime l'objet charge
        virtual void draw();
};

class CbobTex : public Cbob
{
    protected:
        GLuint texId;
        
    public:
        CbobTex();
        virtual ~CbobTex();
        
        bool loadObj(char *fname,GLuint texId=0xFFFFFFFF,float scale=1.0,float tx=0.0,float ty=0.0,float tz=0.0);
        
        void draw();
};

class CbobRefTex : public CbobTex
{
    public:
        CbobRefTex();
        CbobRefTex(Cbob *bob,GLuint texId=0xFFFFFFFF);
        ~CbobRefTex();
        
        virtual void clear();//cette clase n'est qu'une rfrence  un objet charg
};    

//Binary object Oriented
class CbobOBJ
{
    private:
        Cbob *bob;
        
        matrix mtx;
        
    public:
        CbobOBJ();
        ~CbobOBJ();
        
        bool loadObj(Cbob *bob);
        //bool loadObj(char *fname,float scale=1.0,float tx=0.0,float ty=0.0,float tz=0.0);
        //bool loadObj(char *fname,GLuint texId,float scale=1.0,float tx=0.0,float ty=0.0,float tz=0.0);
        void clear();
        
        void setPosition(float px,float py,float pz);
        void setPositionZ(float pz);
        void setOrientation(float vx,float vy,float vz,bool inv=false);//s'oriente vers une direction
        void setOrientationN(float vx,float vy,float vz,bool inv=false);//suppose vx,vy,vz dja normalis
        void setRotation(float angleX,float angleY,float angleZ);//yawn pitch roll
        //void setRotationQuat(float angleX,float angleY,float angleZ);
        
        void getAxeX(Vecteur &r); // obtenir les axes de la nouvelles base de l'objet
        void getAxeY(Vecteur &r);
        void getAxeZ(Vecteur &r);
        void multVect(Vecteur &r,Vecteur v);
        
        void draw();//dessiner l'objet en appliquant a matrice de rotation et translation actuelle
        void draw(float px,float py,float pz);//dessiner en mtant  jour la position
        
        void addPos(Vecteur &p);// ajouter la position de l'objet  ce vecteur
        float getPosY();//obtenir juste la position en Y de l'objet
        
        void applyMatrix(); // la matrice de l'objet
};

//Classe des prototypes
class CPrototypesBobs
{
    private:
        unsigned char nbBob;//nombre de prototype
        Cbob **tabBob;//table des prototypes
        
    public:
        CPrototypesBobs();
        ~CPrototypesBobs();
        
        void initPrototypes();//Charger les prototypes
        void clear();//Dcharger les prototypes
        
        Cbob *getPrototype(unsigned char id);//Obtenir un modles
};

#endif
